import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:chiseled_smooth_basalt_bricks', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            if (selectedItem?.typeId === 'minecraft:amethyst_shard') {
                block.setType('v360:amethyst_chiseled_smooth_basalt_bricks')
                block.dimension.playSound('respawn_anchor.charge', block.location)
                block.dimension.spawnParticle('v360:amethyst_chiseled_smooth_basalt_brick', { x: x, y: y + 0.5, z: z })
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s minecraft:amethyst_shard 0 1`)
                }
            }
            if (selectedItem?.typeId === 'v360:citrine_shard') {
                block.setType('v360:citrine_chiseled_smooth_basalt_bricks')
                block.dimension.playSound('respawn_anchor.charge', block.location)
                block.dimension.spawnParticle('v360:citrine_chiseled_smooth_basalt_brick', { x: x, y: y + 0.5, z: z })
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s v360:citrine_shard 0 1`)
                }
            }
            if (selectedItem?.typeId === 'v360:garnet_shard') {
                block.setType('v360:garnet_chiseled_smooth_basalt_bricks')
                block.dimension.playSound('respawn_anchor.charge', block.location)
                block.dimension.spawnParticle('v360:garnet_chiseled_smooth_basalt_brick', { x: x, y: y + 0.5, z: z })
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s v360:garnet_shard 0 1`)
                }
            }
            if (selectedItem?.typeId === 'v360:jade_shard') {
                block.setType('v360:jade_chiseled_smooth_basalt_bricks')
                block.dimension.playSound('respawn_anchor.charge', block.location)
                block.dimension.spawnParticle('v360:jade_chiseled_smooth_basalt_brick', { x: x, y: y + 0.5, z: z })
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s v360:jade_shard 0 1`)
                }
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:amethyst_chiseled_smooth_basalt_brick', {
        onPlayerInteract({ block, player }) {
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            if (selectedItem?.typeId === 'v360:chisel') {
                block.setType('v360:chiseled_smooth_basalt_bricks')
                block.dimension.spawnItem(new ItemStack('minecraft:amethyst_shard', 1), block.center())
                block.dimension.playSound('respawn_anchor.deplete', block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:citrine_chiseled_smooth_basalt_brick', {
        onPlayerInteract({ block, player }) {
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            if (selectedItem?.typeId === 'v360:chisel') {
                block.setType('v360:chiseled_smooth_basalt_bricks')
                block.dimension.spawnItem(new ItemStack('v360:citrine_shard', 1), block.center())
                block.dimension.playSound('respawn_anchor.deplete', block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:garnet_chiseled_smooth_basalt_brick', {
        onPlayerInteract({ block, player }) {
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            if (selectedItem?.typeId === 'v360:chisel') {
                block.setType('v360:chiseled_smooth_basalt_bricks')
                block.dimension.spawnItem(new ItemStack('v360:garnet_shard', 1), block.center())
                block.dimension.playSound('respawn_anchor.deplete', block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:jade_chiseled_smooth_basalt_brick', {
        onPlayerInteract({ block, player }) {
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            if (selectedItem?.typeId === 'v360:chisel') {
                block.setType('v360:chiseled_smooth_basalt_bricks')
                block.dimension.spawnItem(new ItemStack('v360:jade_shard', 1), block.center())
                block.dimension.playSound('respawn_anchor.deplete', block.location)
            }
        }
    })
})